<?php
// Cargar WordPress
require_once(__DIR__ . '/../../../wordpress/wp-load.php');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Red de Egresados UNSM - Sistema de Seguimiento al Egresado e Inserción Laboral de la Universidad Nacional de San Martín">
    <title>Red de Egresados - Seguimiento al Egresado e Inserción Laboral | UNSM</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../../../imagenes/escudo unsm.png" sizes="48x48">

    <!-- Stylesheets -->
    <link rel="stylesheet" href="../../../css/style.css">
    <link rel="stylesheet" href="css/styleSegui.css">
    
    <!-- Font Awesome para iconos -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <!-- Skip to main content for accessibility -->
    <a href="#main-content" class="skip-to-content">Saltar al contenido principal</a>

    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en Facebook">
                    <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="36" height="36">
                </a>
                <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" title="Síguenos en Instagram">
                    <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="36" height="36">
                </a>
                <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" title="Visita nuestro canal de YouTube">
                    <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="36" height="36">
                </a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en X (Twitter)">
                    <img src="../../../imagenes/redes/logo x.png" alt="X (Twitter)" width="36" height="36">
                </a>
                <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" title="Síguenos en TikTok">
                    <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="36" height="36">
                </a>
            </nav>
            <div class="contact-info">
                <span>
                    <img src="../../../imagenes/logo telefono.png" alt="Teléfono" class="contact-icon" width="18" height="18">
                    <span>(+51) (042) 48 0159</span>
                </span>
                <span>
                    <img src="../../../imagenes/logo correo.png" alt="Correo" class="contact-icon" width="18" height="18">
                    <span>informes@unsm.edu.pe</span>
                </span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="../../../index.php" aria-label="Ir a la página principal de UNSM">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo de la Universidad Nacional de San Martín" width="auto" height="70">
                </a>
            </div>

            <!-- Botón Hamburguesa para móvil -->
            <button class="mobile-menu-toggle" aria-label="Abrir menú de navegación" aria-expanded="false" aria-controls="main-navigation">
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
            </button>

            <nav class="main-nav" id="main-navigation" aria-label="Navegación principal">
                <!-- Logo en menú móvil -->
                <div class="mobile-nav-logo">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="65">
                </div>

                <ul class="nav-menu">
                    <li class="dropdown">
                        <a href="#nosotros" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                        <ul class="dropdown-menu" aria-label="Menú Nosotros">
                            <li><a href="../../../nosotros/autoridades/indexAuto.php">Autoridades</a></li>
                            <li><a href="../../../nosotros/historia/historia.php">Historia de la Universidad</a></li>
                            <li><a href="../../../nosotros/mision/indexMision.php">Nuestra Misión y Visión</a></li>
                            <li><a href="../../../nosotros/objetivos/objeIndex.php">Objetivos</a></li>
                            <li><a href="../../../nosotros/onigrama/indexOni.php">Organigrama</a></li>
                            <li><a href="../../../nosotros/himno/indexHimno.php">Himno</a></li>
                            <li><a href="../../../nosotros/directorioInstucional/indexDirec.php">Directorio Institucional</a></li>
                            <li><a href="../../../nosotros/calendarioAcade/indexCale.php">Calendario Académico</a></li>
                        </ul>
                    </li>
                    <li class="dropdown dropdown-wide">
                        <a href="#oficinas" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                        <ul class="dropdown-menu dropdown-columns" aria-label="Menú Oficinas">
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Administrativas</li>
                                <li><a href="../../../oficinas/rectorado/indexRecto.php">Rectorado</a></li>
                                <li><a href="../../../oficinas/vicerrectorado academico/indexVicerec.php">Vicerrectorado Académico</a></li>
                                <li><a href="../../../oficinas/vicerrectorado de investigacion/indexViceRecAca.php">Vicerrectorado de Investigación</a></li>
                                <li><a href="../../../oficinas/secretaria general/indexSecreGene.php">Secretaría General</a></li>
                                <li><a href="../../../oficinas/planeamiento y presupuesto/indexPlanea.php">Planeamiento y Presupuesto</a></li>
                                <li><a href="../../../oficinas/seguridad y salud ocupacional/indexSeguri.php">Seguridad y Salud Ocupacional</a></li>
                                <li><a href="../../../oficinas/comunicacion y imagen institucional/indexImagen.php">Comunicación e Imagen Institucional</a></li>
                                <li><a href="../../../oficinas/Cooperacion y Relaciones Internacionales/indexCoopera.php">Cooperación y Relaciones Internacionales</a></li>
                                <li><a href="../../../oficinas/Organo de Control Institucional/indexOrgaConIns.php">Órgano de Control Institucional</a></li>
                                <li><a href="../../../oficinas/Ejecutora de Inversiones/indexEjec.php">Ejecutora de Inversiones</a></li>
                                <li><a href="../../../oficinas/Asesoria Juridica/indexAseJuri.php">Asesoría Jurídica</a></li>
                                <li><a href="../../../oficinas/Grados y Titulos/indexGrados.php">Grados y Títulos</a></li>
                            </div>
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Académicas</li>
                                <li><a href="../../../oficinas/Academicos/OFICINA DE ADMISION/indexOfiAdmin.php">Oficina de Admisión</a></li>
                                <li><a href="../../../oficinas/Academicos/ASUNTOS ACADEMICOS/indexAsunAca.php">Asuntos Académicos</a></li>
                                <li><a href="indexSegui.php">Seguimiento al Egresado e Inserción Laboral</a></li>
                                <li><a href="../../../index.php#tecnologias">Tecnologías de la Información</a></li>
                                <li><a href="../../../index.php#incubadora">Incubadora de Empresas</a></li>
                                <li><a href="../../../index.php#fondo-editorial">Fondo Editorial</a></li>
                                <li><a href="../../../index.php#comite-electoral">Comité Electoral Universitario</a></li>
                                <li><a href="../../../index.php#innovacion">Innovación y Transferencia Tecnológica</a></li>
                                <li><a href="../../../index.php#produccion">Producción de Bienes y Servicios</a></li>
                                <li><a href="../../../index.php#responsabilidad">Responsabilidad Social Universitaria</a></li>
                                <li><a href="../../../index.php#servicios-generales">Servicios Generales</a></li>
                                <li><a href="../../../index.php#bienestar">Bienestar Universitario</a></li>
                                <li><a href="../../../index.php#defensoria">Defensoría Universitaria</a></li>
                                <li><a href="../../../index.php#calidad">Gestión de la Calidad</a></li>
                            </div>
                        </ul>
                    </li>
                    <li><a href="../../../oficinas/Academicos/OFICINA DE ADMISION/indexOfiAdmin.php">ADMISIÓN</a></li>
                    <li><a href="../../../index.php#cpu">CPU</a></li>
                    <li class="dropdown dropdown-facultades">
                        <a href="../../../index.php#facultades" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                        <ul class="dropdown-menu" aria-label="Menú Facultades">
                            <li class="has-submenu">
                                <a href="../../../index.php#ciencias-agrarias" aria-haspopup="true" aria-expanded="false">Ciencias Agrarias</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Agrarias">
                                    <li><a href="../../../index.php#agronomia">Agronomía</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../index.php#ciencias-salud" aria-haspopup="true" aria-expanded="false">Ciencias de la Salud</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias de la Salud">
                                    <li><a href="../../../index.php#obstetricia">Obstetricia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../index.php#medicina-veterinaria" aria-haspopup="true" aria-expanded="false">Medicina Veterinaria</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Veterinaria">
                                    <li><a href="../../../index.php#medicina-veterinaria-carrera">Medicina Veterinaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../index.php#ingenieria-agroindustrial" aria-haspopup="true" aria-expanded="false">Ingeniería Agroindustrial</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería Agroindustrial">
                                    <li><a href="../../../index.php#ing-agroindustrial">Ingeniería Agroindustrial</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../index.php#ingenieria-civil" aria-haspopup="true" aria-expanded="false">Ingeniería Civil y Arquitectura</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería Civil y Arquitectura">
                                    <li><a href="../../../index.php#arquitectura">Arquitectura</a></li>
                                    <li><a href="../../../index.php#ingenieria-civil-carrera">Ingeniería Civil</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../index.php#ingenieria-sistemas" aria-haspopup="true" aria-expanded="false">Ingeniería de Sistemas e Informática</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería de Sistemas">
                                    <li><a href="../../../index.php#ing-sistemas">Ingeniería de Sistemas e Informática</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../index.php#ecologia" aria-haspopup="true" aria-expanded="false">Ecología</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ecología">
                                    <li><a href="../../../index.php#ing-ambiental">Ingeniería Ambiental</a></li>
                                    <li><a href="../../../index.php#ing-sanitaria">Ingeniería Sanitaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../index.php#derecho" aria-haspopup="true" aria-expanded="false">Derecho y Ciencias Políticas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Derecho">
                                    <li><a href="../../../index.php#derecho-carrera">Derecho</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../index.php#medicina-humana" aria-haspopup="true" aria-expanded="false">Medicina Humana</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Humana">
                                    <li><a href="../../../index.php#medicina-humana-carrera">Medicina Humana</a></li>
                                    <li><a href="../../../index.php#enfermeria">Enfermería</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../index.php#ciencias-economicas" aria-haspopup="true" aria-expanded="false">Ciencias Económicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Económicas">
                                    <li><a href="../../../index.php#administracion">Administración</a></li>
                                    <li><a href="../../../index.php#contabilidad">Contabilidad</a></li>
                                    <li><a href="../../../index.php#economia">Economía</a></li>
                                    <li><a href="../../../index.php#turismo">Turismo</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../index.php#educacion" aria-haspopup="true" aria-expanded="false">Educación y Humanidades</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Educación">
                                    <li><a href="../../../index.php#educacion-inicial">Educación Inicial</a></li>
                                    <li><a href="../../../index.php#educacion-primaria">Educación Primaria</a></li>
                                    <li><a href="../../../index.php#educacion-secundaria">Educación Secundaria</a></li>
                                    <li><a href="../../../index.php#idiomas">Idiomas</a></li>
                                    <li>
                                        <a href="../../../index.php#psicologia">
                                            Psicología
                                            <span class="badge-nuevo">Nuevo</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="../../../index.php#posgrado">POSGRADO</a></li>
                    <li class="dropdown">
                        <a href="../../../index.php#transparencia" aria-haspopup="true" aria-expanded="false">TRANSPARENCIA</a>
                        <ul class="dropdown-menu" aria-label="Menú Transparencia">
                            <li><a href="../../../index.php#licenciamiento">Licenciamiento</a></li>
                            <li><a href="../../../index.php#institucional">Institucional Ley 30220</a></li>
                            <li><a href="../../../index.php#estandar">Estándar Ley 27806</a></li>
                        </ul>
                    </li>
                </ul>

                <!-- Logos gob.pe dentro del menú móvil -->
                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia de la UNSM">
                        <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Portal del Gobierno del Perú">
                        <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Perú" width="auto" height="35">
                    </a>
                </div>
            </nav>

            <div class="gob-logos">
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia">
                    <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Gobierno del Perú">
                    <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Perú" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>

    <!-- Carrusel Principal de Egresados -->
    <section class="egresados-carousel">
        <!-- Slide 1 -->
        <div class="carousel-slide-egresados" style="opacity: 1;">
            <div class="carousel-image" style="background-image: url('imagenes/graduaccion.jpg');"></div>
            <div class="carousel-overlay"></div>
            <div class="carousel-content">
                <h1 class="carousel-title">#SoyEgresadoUNSM</h1>
                <p class="carousel-subtitle">Red de Egresados - Unidos por el Éxito</p>
            </div>
        </div>

        <!-- Slide 2 -->
        <div class="carousel-slide-egresados" style="opacity: 0;">
            <div class="carousel-image" style="background-image: url('imagenes/certificado.jpg');"></div>
            <div class="carousel-overlay"></div>
            <div class="carousel-content">
                <h1 class="carousel-title">Seguimiento al Egresado</h1>
                <p class="carousel-subtitle">Acompañamiento en tu desarrollo profesional</p>
            </div>
        </div>

        <!-- Slide 3 -->
        <div class="carousel-slide-egresados" style="opacity: 0;">
            <div class="carousel-image" style="background-image: url('imagenes/virtual.jpg');"></div>
            <div class="carousel-overlay"></div>
            <div class="carousel-content">
                <h1 class="carousel-title">Inserción Laboral</h1>
                <p class="carousel-subtitle">Conectamos tu talento con oportunidades</p>
            </div>
        </div>

        <!-- Controles del carrusel -->
        <button class="carousel-control prev" onclick="changeSlideEgresados(-1)" aria-label="Anterior">
            <i class="fas fa-chevron-left"></i>
        </button>
        <button class="carousel-control next" onclick="changeSlideEgresados(1)" aria-label="Siguiente">
            <i class="fas fa-chevron-right"></i>
        </button>

        <!-- Indicadores -->
        <div class="carousel-indicators">
            <span class="carousel-indicator-egresados active" onclick="goToSlideEgresados(0)"></span>
            <span class="carousel-indicator-egresados" onclick="goToSlideEgresados(1)"></span>
            <span class="carousel-indicator-egresados" onclick="goToSlideEgresados(2)"></span>
        </div>
    </section>

    <!-- Banner RED DE EGRESADOS -->
    <section class="banner-red-egresados">
        <div class="banner-content">
            <h2>RED DE EGRESADOS</h2>
        </div>
    </section>

    <!-- Sección Estadísticas de Egresados -->
    <section class="estadisticas-egresados-section">
        <div class="estadisticas-container">
            <!-- Card 1 -->
            <div class="estadistica-card">
                <div class="estadistica-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                        <circle cx="12" cy="7" r="4"></circle>
                    </svg>
                </div>
                <h3 class="estadistica-titulo">Egresados</h3>
                <div class="estadistica-linea"></div>
                <button class="estadistica-btn">Más info.</button>
                <p class="estadistica-numero">12500</p>
                <p class="estadistica-label">Egresados</p>
            </div>

            <!-- Card 2 -->
            <div class="estadistica-card">
                <div class="estadistica-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                        <circle cx="12" cy="7" r="4"></circle>
                    </svg>
                </div>
                <h3 class="estadistica-titulo">Egresados</h3>
                <div class="estadistica-linea"></div>
                <button class="estadistica-btn">Más info.</button>
                <p class="estadistica-numero">1200</p>
                <p class="estadistica-label">Egresados</p>
            </div>

            <!-- Card 3 -->
            <div class="estadistica-card">
                <div class="estadistica-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                        <circle cx="12" cy="7" r="4"></circle>
                    </svg>
                </div>
                <h3 class="estadistica-titulo">Egresados</h3>
                <div class="estadistica-linea"></div>
                <button class="estadistica-btn">Más info.</button>
                <p class="estadistica-numero">56%</p>
                <p class="estadistica-label">Egresados</p>
            </div>

            <!-- Card 4 -->
            <div class="estadistica-card">
                <div class="estadistica-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                        <circle cx="12" cy="7" r="4"></circle>
                    </svg>
                </div>
                <h3 class="estadistica-titulo">Egresados</h3>
                <div class="estadistica-linea"></div>
                <button class="estadistica-btn">Más info.</button>
                <p class="estadistica-numero">60%</p>
                <p class="estadistica-label">Egresados</p>
            </div>
        </div>
    </section>

    <!-- Main Content -->
    <main id="main-content">
        <!-- Sección Informativa Verde -->
        <section class="info-section-green">
            <div class="info-banner-verde">
                <h2>Información y Servicios que ofrecen</h2>
            </div>
        </section>

        <!-- Sección de 3 Columnas: UNIDAD - SERVICIOS - AUTORIDADES -->
        <section class="three-columns-section">
            <div class="container-three-cols">
                <!-- UNIDAD -->
                <article class="info-card">
                    <div class="card-header-icon">
                        <div class="icon-circle yellow-icon">
                            <i class="fas fa-building"></i>
                        </div>
                        <h3 class="card-title-main">UNIDAD</h3>
                    </div>
                    <div class="card-body-text">
                        <p>La Unidad de Seguimiento del Egresado y Laboral es un órgano de línea del Vicerrectorado Académico que tiene por finalidad:</p>
                        <ul class="info-list">
                            <li>Implementar un sistema de seguimiento al egresado y graduado de la Universidad.</li>
                            <li>Evaluar el impacto de la educación superior en el entorno laboral.</li>
                            <li>Implementar mecanismos de inserción laboral de los estudiantes y egresados con el sector público y privado.</li>
                        </ul>
                    </div>
                </article>

                <!-- SERVICIOS -->
                <article class="info-card">
                    <div class="card-header-icon">
                        <div class="icon-circle yellow-icon">
                            <i class="fas fa-hands-helping"></i>
                        </div>
                        <h3 class="card-title-main">SERVICIOS</h3>
                    </div>
                    <div class="card-body-text">
                        <p>La oficina de Seguimiento y Apoyo al Egresado e Inserción Laboral ofrece:</p>
                        <ul class="info-list">
                            <li>Asesoría de cursos de interés o temas relacionados a tu carrera profesional.</li>
                            <li>Bolsa de trabajo disponible en el Sistema Nacional de Empleos-Perú (OPUS).</li>
                            <li>Encuestas disponibles para conocer las actividades que realiza el egresado.</li>
                            <li>Talleres de orientación profesional y oportunidades laborales.</li>
                        </ul>
                    </div>
                </article>

                <!-- AUTORIDADES -->
                <article class="info-card autoridades-card">
                    <div class="card-header-icon">
                        <div class="icon-circle yellow-icon">
                            <i class="fas fa-user-tie"></i>
                        </div>
                        <h3 class="card-title-main">AUTORIDADES</h3>
                    </div>
                    <div class="card-body-autoridad">
                        <div class="autoridad-photo">
                            <img src="imagenes/jefa de seguimiento.jpeg" alt="Responsable de la Unidad" loading="lazy">
                        </div>
                        <div class="autoridad-info">
                            <h4 class="autoridad-nombre">Dra. Enma Yolanda Linares Bustamante</h4>
                            <p class="autoridad-cargo">Jefa de la Unidad de Seguimiento al Egresado e Inserción Laboral</p>
                        </div>
                    </div>
                </article>
            </div>
        </section>

        <!-- Banner Verde Segundo -->
        <section class="info-section-green">
            <div class="info-banner-verde">
                <h2>Información y Servicios que ofrecen</h2>
            </div>
        </section>

        <!-- Sección FUNCIONES con Documento -->
        <section class="functions-section">
            <div class="functions-container">
                <article class="functions-content">
                    <div class="card-header-icon">
                        <div class="icon-circle yellow-icon">
                            <i class="fas fa-list-ul"></i>
                        </div>
                        <h3 class="card-title-main">FUNCIONES</h3>
                    </div>
                    <div class="functions-text">
                        <ul class="functions-list">
                            <li>Planificar y ejecutar las actividades de seguimiento a egresados.</li>
                            <li>Organizar y actualizar la base de datos de los egresados de la universidad.</li>
                            <li>Promover los servicios de apoyo al egresado en coordinación con las Facultades.</li>
                            <li>Elaborar y difundir información sobre oferta y demanda laboral en el ámbito regional.</li>
                            <li>Realizar encuestas de seguimiento a egresados para evaluar su inserción laboral.</li>
                            <li>Coordinar con empleadores para identificar competencias requeridas.</li>
                            <li>Desarrollar programas de capacitación y actualización profesional.</li>
                            <li>Elaborar estudios sobre la situación laboral de los egresados.</li>
                            <li>Mantener vínculos con instituciones públicas y privadas para promover la inserción laboral.</li>
                            <li>Facilitar espacios para compartir experiencias laborales entre egresados.</li>
                            <li>Promover el emprendimiento y la creación de empresas entre egresados.</li>
                            <li>Otras funciones asignadas por el Vicerrectorado Académico.</li>
                        </ul>
                    </div>
                </article>

                <aside class="functions-document">
                    <div class="document-preview">
                        <img src="imagenes/doc-funciones.jpg" alt="Documento de funciones" loading="lazy">
                    </div>
                </aside>
            </div>
        </section>

        <!-- Banner Interes Comun -->
        <section class="banner-interes-comun">
            <div class="banner-content">
                <h2>Interés Común</h2>
            </div>
        </section>

        <!-- Sección Noticias y Eventos -->
        <section class="noticias-eventos-section">
            <div class="container-standard">
                <div class="section-grid-2cols">
                    <!-- Noticias y Eventos -->
                    <div class="news-events-column">
                        <h2 class="section-title-secondary">Noticias y Eventos</h2>
                        <div class="news-cards-grid">
                            <article class="news-card-small">
                                <div class="news-image-small">
                                    <img src="imagenes/noticia1.jpg" alt="Noticia 1" loading="lazy">
                                </div>
                                <div class="news-content-small">
                                    <span class="news-date-small">15/11/2024</span>
                                    <h3 class="news-title-small">ENTREVISTA: "EL EMPODERAMIENTO DE LOS EGRESADOS MEDIANTE UN SEGUIMIENTO ACADÉMICO Y LABORAL ADECUADO"</h3>
                                    <p class="news-excerpt-small">Entrevista exclusiva sobre la importancia del seguimiento a egresados...</p>
                                </div>
                            </article>

                            <article class="news-card-small">
                                <div class="news-image-small">
                                    <img src="imagenes/noticia2.jpg" alt="Noticia 2" loading="lazy">
                                </div>
                                <div class="news-content-small">
                                    <span class="news-date-small">10/11/2024</span>
                                    <h3 class="news-title-small">I ENCUENTRO DE EGRESADOS Y GRADUADOS DE LA FACULTAD DE CIENCIAS DE LA SALUD</h3>
                                    <p class="news-excerpt-small">Exitoso encuentro que reunió a más de 200 egresados...</p>
                                </div>
                            </article>

                            <article class="news-card-small">
                                <div class="news-image-small">
                                    <img src="imagenes/noticia3.jpg" alt="Noticia 3" loading="lazy">
                                </div>
                                <div class="news-content-small">
                                    <span class="news-date-small">05/11/2024</span>
                                    <h3 class="news-title-small">TALLER: "OPORTUNIDADES LABORALES Y EMPRENDIMIENTO PARA EGRESADOS UNSM"</h3>
                                    <p class="news-excerpt-small">Capacitación sobre herramientas para la búsqueda de empleo...</p>
                                </div>
                            </article>
                        </div>
                    </div>

                    <!-- Contactos -->
                    <div class="contactos-column">
                        <h2 class="section-title-secondary">Contactos</h2>
                        <div class="contact-info-box">
                            <div class="contact-item">
                                <i class="fas fa-map-marker-alt contact-icon-large"></i>
                                <div class="contact-text">
                                    <h4>DIRECCIÓN:</h4>
                                    <p>Jr. Maynas N° 177, Morales</p>
                                    <p>Tarapoto - San Martín - Perú</p>
                                </div>
                            </div>

                            <div class="contact-item">
                                <i class="fas fa-phone contact-icon-large"></i>
                                <div class="contact-text">
                                    <h4>TELÉFONO:</h4>
                                    <p>(042) 48 0159 - Anexo 235</p>
                                </div>
                            </div>

                            <div class="contact-item">
                                <i class="fas fa-envelope contact-icon-large"></i>
                                <div class="contact-text">
                                    <h4>CORREO ELECTRÓNICO:</h4>
                                    <p>seguimiento.egresado@unsm.edu.pe</p>
                                </div>
                            </div>

                            <div class="contact-item">
                                <i class="fas fa-clock contact-icon-large"></i>
                                <div class="contact-text">
                                    <h4>HORARIO DE ATENCIÓN:</h4>
                                    <p>Lunes a Viernes</p>
                                    <p>08:00 am - 05:00 pm</p>
                                </div>
                            </div>
                        </div>

                        <!-- Sistema de Bolsa de Trabajo -->
                        <div class="opus-system-box">
                            <h3 class="opus-title">Sistema de Bolsa de Trabajo</h3>
                            <div class="opus-logo-container">
                                <img src="imagenes/opus-logo.png" alt="OPUS - Bolsa de Trabajo" loading="lazy">
                                <p class="opus-subtitle">Bolsa de Trabajo</p>
                            </div>
                            <a href="https://www.empleosperu.gob.pe/" target="_blank" rel="noopener noreferrer" class="btn-opus">Acceder a OPUS</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Cursos de Interés -->
        <section class="cursos-interes-section">
            <div class="container-standard">
                <h2 class="section-title-center">Cursos de Interés</h2>
                <div class="cursos-grid">
                    <article class="curso-card">
                        <div class="curso-image">
                            <img src="imagenes/curso1.jpg" alt="Curso de Excel Avanzado" loading="lazy">
                        </div>
                        <div class="curso-content">
                            <h3 class="curso-title">CURSO: EXCEL AVANZADO PARA PROFESIONALES</h3>
                            <p class="curso-description">Domina las herramientas avanzadas de Excel para el análisis de datos y reportes profesionales.</p>
                            <div class="curso-footer">
                                <span class="curso-duracion"><i class="fas fa-clock"></i> 40 horas</span>
                                <a href="#curso1" class="btn-curso">Más información</a>
                            </div>
                        </div>
                    </article>

                    <article class="curso-card">
                        <div class="curso-image">
                            <img src="imagenes/curso2.jpg" alt="Curso de Gestión de Proyectos" loading="lazy">
                        </div>
                        <div class="curso-content">
                            <h3 class="curso-title">CURSO: GESTIÓN DE PROYECTOS CON METODOLOGÍAS ÁGILES</h3>
                            <p class="curso-description">Aprende a gestionar proyectos utilizando Scrum, Kanban y otras metodologías ágiles.</p>
                            <div class="curso-footer">
                                <span class="curso-duracion"><i class="fas fa-clock"></i> 60 horas</span>
                                <a href="#curso2" class="btn-curso">Más información</a>
                            </div>
                        </div>
                    </article>

                    <article class="curso-card">
                        <div class="curso-image">
                            <img src="imagenes/curso3.jpg" alt="Curso de Marketing Digital" loading="lazy">
                        </div>
                        <div class="curso-content">
                            <h3 class="curso-title">CURSO: MARKETING DIGITAL Y REDES SOCIALES</h3>
                            <p class="curso-description">Estrategias efectivas de marketing digital para impulsar tu marca o negocio en línea.</p>
                            <div class="curso-footer">
                                <span class="curso-duracion"><i class="fas fa-clock"></i> 50 horas</span>
                                <a href="#curso3" class="btn-curso">Más información</a>
                            </div>
                        </div>
                    </article>
                </div>
            </div>
        </section>

        <!-- Convocatorias -->
        <section class="convocatorias-section">
            <div class="container-standard">
                <h2 class="section-title-center">Convocatorias</h2>
                <?php
                // Obtener convocatorias desde WordPress (categoría "Convocatorias")
                $convocatorias_args = array(
                    'post_type'      => 'post',
                    'posts_per_page' => 3,
                    'orderby'        => 'date',
                    'order'          => 'DESC',
                    'post_status'    => 'publish',
                    'category_name'  => 'convocatorias'
                );

                $convocatorias_query = new WP_Query($convocatorias_args);

                if ($convocatorias_query->have_posts()) : ?>
                    <div class="convocatorias-grid">
                        <?php while ($convocatorias_query->have_posts()) : $convocatorias_query->the_post(); ?>
                            <article class="convocatoria-card">
                                <div class="convocatoria-image">
                                    <?php if (has_post_thumbnail()) : ?>
                                        <?php the_post_thumbnail('medium', array('alt' => get_the_title(), 'loading' => 'lazy')); ?>
                                    <?php else : ?>
                                        <img src="imagenes/convocatoria1.jpg" alt="<?php echo esc_attr(get_the_title()); ?>" loading="lazy">
                                    <?php endif; ?>
                                </div>
                                <div class="convocatoria-content">
                                    <h3 class="convocatoria-title"><?php the_title(); ?></h3>
                                    <p class="convocatoria-date"><i class="fas fa-calendar"></i> <?php echo get_the_date('d/m/Y'); ?></p>
                                    <a href="<?php echo get_permalink(); ?>" class="btn-convocatoria">Ver detalles</a>
                                </div>
                            </article>
                        <?php endwhile; ?>
                    </div>
                <?php else : ?>
                    <div class="convocatorias-grid">
                        <p style="text-align: center; padding: 40px; color: #666; grid-column: 1 / -1;">No hay convocatorias disponibles en este momento.</p>
                    </div>
                <?php endif; ?>
                <?php wp_reset_postdata(); ?>
            </div>
        </section>

        <!-- Encuestas -->
        <section class="encuestas-section">
            <div class="container-standard">
                <h2 class="section-title-center">Encuestas</h2>
                <div class="encuestas-grid">
                    <article class="encuesta-card">
                        <div class="encuesta-icon">
                            <i class="fas fa-clipboard-check"></i>
                        </div>
                        <div class="encuesta-content">
                            <h3 class="encuesta-title">Encuesta de Satisfacción Laboral para Egresados</h3>
                            <p class="encuesta-description">Ayúdanos a conocer tu situación laboral actual y tu nivel de satisfacción profesional.</p>
                            <a href="#encuesta1" class="btn-encuesta">Participar</a>
                        </div>
                    </article>

                    <article class="encuesta-card">
                        <div class="encuesta-icon">
                            <i class="fas fa-clipboard-check"></i>
                        </div>
                        <div class="encuesta-content">
                            <h3 class="encuesta-title">Encuesta de Calidad Formativa UNSM</h3>
                            <p class="encuesta-description">Evalúa la calidad de la formación académica que recibiste en la UNSM.</p>
                            <a href="#encuesta2" class="btn-encuesta">Participar</a>
                        </div>
                    </article>

                    <article class="encuesta-card">
                        <div class="encuesta-icon">
                            <i class="fas fa-clipboard-check"></i>
                        </div>
                        <div class="encuesta-content">
                            <h3 class="encuesta-title">Encuesta de Necesidades de Capacitación</h3>
                            <p class="encuesta-description">Indícanos qué cursos o talleres te gustaría recibir para mejorar tus competencias.</p>
                            <a href="#encuesta3" class="btn-encuesta">Participar</a>
                        </div>
                    </article>
                </div>
            </div>
        </section>

        <!-- Banner Documentos Normativos -->
        <section class="banner-documentos">
            <div class="banner-content">
                <h2>Documentos Normativos para Egresar</h2>
            </div>
        </section>

        <!-- Sección Te Cuenta tu Experiencia + Noticias -->
        <section class="experiencia-noticias-section">
            <div class="container-standard">
                <div class="section-grid-2cols-custom">
                    <!-- Columna Izquierda: Te Cuenta tu Experiencia -->
                    <div class="experiencia-column">
                        <div class="experiencia-content">
                            <div class="experiencia-header">
                                <div class="badge-yellow">Te es cuenta tu</div>
                                <h2 class="experiencia-title">Experiencia</h2>
                            </div>
                            <div class="experiencia-illustration">
                                <img src="imagenes/estudiante-ilustracion.png" alt="Estudiante egresado" loading="lazy">
                            </div>
                            <p class="experiencia-text">Comparte tu historia como egresado de la UNSM. Tu experiencia puede inspirar a otros estudiantes y egresados.</p>
                            <a href="#compartir-experiencia" class="btn-experiencia">Compartir mi historia</a>
                        </div>
                    </div>

                    <!-- Columna Derecha: Últimas Noticias -->
                    <div class="noticias-recientes-column">
                        <h3 class="noticias-recientes-title">Últimas Noticias</h3>
                        <div class="noticias-recientes-list">
                            <article class="noticia-reciente-item">
                                <div class="noticia-reciente-image">
                                    <img src="imagenes/mini-noticia1.jpg" alt="Noticia reciente 1" loading="lazy">
                                </div>
                                <div class="noticia-reciente-content">
                                    <span class="noticia-reciente-fecha">30 noviembre de 2024</span>
                                    <h4 class="noticia-reciente-title">El gran impacto de docentes de la Facultad de Educación de la UNSM en diferentes proyectos</h4>
                                    <p class="noticia-reciente-excerpt">Destacados docentes han desarrollado importantes proyectos de impacto social...</p>
                                </div>
                            </article>

                            <article class="noticia-reciente-item">
                                <div class="noticia-reciente-image">
                                    <img src="imagenes/mini-noticia2.jpg" alt="Noticia reciente 2" loading="lazy">
                                </div>
                                <div class="noticia-reciente-content">
                                    <span class="noticia-reciente-fecha">28 noviembre de 2024</span>
                                    <h4 class="noticia-reciente-title">Docente de la Facultad de Ciencias Agrarias fue reconocido por su aporte científico</h4>
                                    <p class="noticia-reciente-excerpt">Por su destacada investigación en agricultura sostenible...</p>
                                </div>
                            </article>

                            <article class="noticia-reciente-item">
                                <div class="noticia-reciente-image">
                                    <img src="imagenes/mini-noticia3.jpg" alt="Noticia reciente 3" loading="lazy">
                                </div>
                                <div class="noticia-reciente-content">
                                    <span class="noticia-reciente-fecha">25 noviembre de 2024</span>
                                    <h4 class="noticia-reciente-title">UNSM realizó el Foro Forestal Internacional 2024 con destacados expositores</h4>
                                    <p class="noticia-reciente-excerpt">Evento que reunió a especialistas nacionales e internacionales...</p>
                                </div>
                            </article>

                            <article class="noticia-reciente-item">
                                <div class="noticia-reciente-image">
                                    <img src="imagenes/mini-noticia4.jpg" alt="Noticia reciente 4" loading="lazy">
                                </div>
                                <div class="noticia-reciente-content">
                                    <span class="noticia-reciente-fecha">20 noviembre de 2024</span>
                                    <h4 class="noticia-reciente-title">Estudiantes de la UNSM realizaron plantado de árboles en la ciudad de Tarapoto</h4>
                                    <p class="noticia-reciente-excerpt">Iniciativa ambiental que busca reforestar áreas urbanas...</p>
                                </div>
                            </article>
                        </div>
                        <a href="#todas-noticias" class="btn-ver-todas-noticias">Ver todas las noticias <i class="fas fa-arrow-right"></i></a>
                    </div>
                </div>
            </div>
        </section>

        <!-- Documentos para Descargar (2 Cards) -->
        <section class="documentos-section">
            <div class="container-standard">
                <div class="documentos-grid">
                    <article class="documento-card">
                        <div class="documento-icon red-icon">
                            <i class="fas fa-file-alt"></i>
                        </div>
                        <h3 class="documento-title">Ficha de Egresado</h3>
                        <p class="documento-description">Documento necesario para registrarte como egresado de la UNSM y acceder a los servicios de la unidad.</p>
                        <a href="#ficha-egresado" class="btn-documento" download>
                            <i class="fas fa-download"></i> Descargar
                        </a>
                    </article>

                    <article class="documento-card">
                        <div class="documento-icon green-icon">
                            <i class="fas fa-file-pdf"></i>
                        </div>
                        <h3 class="documento-title">Resolución Rectoral</h3>
                        <p class="documento-description">Normativas y resoluciones que regulan el funcionamiento de la Unidad de Seguimiento al Egresado.</p>
                        <a href="#resolucion" class="btn-documento">
                            <i class="fas fa-eye"></i> Ver documento
                        </a>
                    </article>
                </div>
            </div>
        </section>
    </main>

    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="../../../imagenes/escudo unsm.png" alt="Escudo oficial de la UNSM" class="footer-logo" width="60" height="auto">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios autónomo y de carácter estatal, comprometido con la formación de profesionales humanistas y competitivos, con responsabilidad social y comprometidos con el desarrollo local, regional y nacional.</p>
                <address>
                    <p>Jr. Maynas N° 177 - Morales</p>
                    <p>Tarapoto - San Martín - Perú</p>
                    <p>Central Telefónica: <span>(+51) (042) 48 0159</span></p>
                    <p>Email: <span>informes@unsm.edu.pe</span></p>
                </address>
            </section>

            <nav class="footer-section" aria-labelledby="footer-links-title">
                <h3 id="footer-links-title" class="footer-title">Enlaces Rápidos</h3>
                <ul class="footer-links">
                    <li><a href="../../../index.php#admision">Admisión</a></li>
                    <li><a href="../../../index.php#facultades">Facultades</a></li>
                    <li><a href="../../../index.php#posgrado">Posgrado</a></li>
                    <li><a href="../../../index.php#investigacion">Investigación</a></li>
                </ul>
            </nav>

            <nav class="footer-section" aria-labelledby="footer-services-title">
                <h3 id="footer-services-title" class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="#biblioteca">Biblioteca Virtual</a></li>
                    <li><a href="#campus-virtual">Campus Virtual</a></li>
                    <li><a href="#repositorio">Repositorio Institucional</a></li>
                    <li><a href="#transparencia">Portal de Transparencia</a></li>
                    <li><a href="#libro-reclamaciones">Libro de Reclamaciones</a></li>
                    <li><a href="../../../contacto/indexContac.php">Enviar Mensaje</a></li>
                </ul>
            </nav>

            <section class="footer-section footer-facebook" aria-labelledby="footer-facebook-title">
                <h3 id="footer-facebook-title" class="footer-title">Facebook UNSM</h3>
                <div class="fb-page"
                    data-href="https://www.facebook.com/unsmperu"
                    data-tabs="timeline"
                    data-width="320"
                    data-height="320"
                    data-small-header="false"
                    data-adapt-container-width="true"
                    data-hide-cover="false"
                    data-show-facepile="true">
                    <blockquote cite="https://www.facebook.com/unsmperu" class="fb-xfbml-parse-ignore">
                        <a href="https://www.facebook.com/unsmperu">Universidad Nacional de San Martín - UNSM</a>
                    </blockquote>
                </div>
            </section>
        </div>

        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; 2025 Universidad Nacional de San Martín. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">Síguenos</span>
                    <nav class="footer-social" aria-label="Redes sociales de la UNSM">
                        <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="Facebook UNSM">
                            <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="22" height="22">
                        </a>
                        <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" aria-label="Instagram UNSM">
                            <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="22" height="22">
                        </a>
                        <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" aria-label="YouTube UNSM">
                            <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="22" height="22">
                        </a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter) UNSM">
                            <img src="../../../imagenes/redes/logo x.png" alt="X" width="22" height="22">
                        </a>
                        <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" aria-label="TikTok UNSM">
                            <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="22" height="22">
                        </a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="../../../js/script.js"></script>
    <script src="js/scriptSegui.js"></script>

    <!-- Facebook SDK -->
    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/es_LA/sdk.js#xfbml=1&version=v12.0" nonce="random"></script>
</body>
</html>